use master
GO

set nocount on 

--set to 0 to skip updating the A4Panel_Client_Template database, or to 1 to update the template database
declare @ProcessTemplateDB bit = 1  

declare @PanelClientPayload01 nvarchar(max) = N'
-- DEV-79746
-- SP VX_sp_UpsertPanelSurveyStatistics no longer needed
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N''[dbo].[VX_sp_UpsertPanelSurveyStatistics]'') AND type in (N''P'', N''PC''))
	DROP PROCEDURE [dbo].[VX_sp_UpsertPanelSurveyStatistics]
'

declare @PanelClientPayload02 nvarchar(max) = N'
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N''[dbo].[VX_sp_UpdatePanelSurveyStatistics]'') AND type in (N''P'', N''PC''))
	DROP PROCEDURE [dbo].[VX_sp_UpdatePanelSurveyStatistics]
'

declare @PanelClientPayload03 nvarchar(max) = N'
CREATE PROCEDURE [dbo].[VX_sp_UpdatePanelSurveyStatistics]
	@surveyId int
AS
BEGIN
	SET NOCOUNT ON;
	SET DEADLOCK_PRIORITY LOW;

    DECLARE @panelDatabase nvarchar(64) = DB_NAME();
    DECLARE @clientId int = dbo.GetClientId(@panelDatabase);
    DECLARE @clientIdString nvarchar(8) = CONVERT(nvarchar, @clientId);
    DECLARE @surveyDatabase nvarchar(40) = ''A4Survey_Client_'' + @clientIdString;
    DECLARE @surveySchema nvarchar(50) = ''Survey_'' + @clientIdString + ''_'' + CONVERT(nvarchar, @surveyId);

    DECLARE @stmt nvarchar(MAX) = ''
    SELECT p.[Panel_Id] AS [PanelId],
           COUNT(*) AS [Linked],
           SUM(CASE WHEN r.[ResCompleted] = 0 THEN 0 ELSE 1 END) AS [Completed],
           SUM(CASE WHEN act.[PanelistId] IS NULL THEN 0 ELSE 1 END) AS [Participated]
    INTO #Stats
    FROM ['' + @panelDatabase + ''].[dbo].[Panelists] p WITH(NOLOCK)
    INNER JOIN ['' + @surveyDatabase + ''].['' + @surveySchema + ''].[Respondent] r WITH(NOLOCK) on r.[panelistId] = p.[Id]
    LEFT JOIN (
        SELECT ah.[PanelistId]
        FROM ['' + @panelDatabase + ''].[dbo].[ActivityHistories] ah WITH(NOLOCK)
        INNER JOIN ['' + @panelDatabase + ''].[dbo].[ActivityHistories_SurveyActivityHistory] sah WITH(NOLOCK) ON sah.[Id] = ah.[Id]
        WHERE ah.[SurveyId] = @surveyId AND sah.[DispositionCode] IN (1,3,5)
        GROUP BY ah.[PanelistId]
    ) act ON act.[PanelistId] = p.[Id]
    GROUP BY p.[Panel_Id]

    DECLARE @panelCount INT = @@ROWCOUNT;

    UPDATE pss
    SET pss.[Linked] = s.[Linked],
        pss.[Completed] = s.[Completed],
        pss.[Participated] = s.[Participated]
    FROM #Stats s
    INNER JOIN ['' + @panelDatabase + ''].[dbo].PanelSurveyStatistics pss ON pss.[PanelId] = s.[PanelId] and pss.[SurveyId] = @surveyId;

    DECLARE @updatedPanelCount INT = @@ROWCOUNT;

    IF @panelCount <> @updatedPanelCount
    BEGIN
        INSERT INTO ['' + @panelDatabase + ''].[dbo].[PanelSurveyStatistics] ([PanelId], [SurveyId], [Linked], [Completed], [Participated])
        SELECT s.[PanelId], @surveyId, s.[Linked], s.[Completed], s.[Participated]
        FROM #Stats s
        LEFT JOIN ['' + @panelDatabase + ''].[dbo].[PanelSurveyStatistics] pss on pss.[PanelId] = s.[PanelId] and pss.[SurveyId] = @surveyId
        WHERE pss.[PanelId] IS NULL;
    END

    DROP TABLE #Stats;
    '';

    EXEC sp_executesql @stmt, N''@surveyId int'', @surveyId;
END
'

create table #DB (
	DBName nvarchar(128),
	Processed tinyint default 0
)

declare @AllDone bit = 0, 
        @TotalPanelClients int, 
		@PanelClientCounter int, 
		@ThisPanelClient nvarchar(128), 
		@PanelClientCursor cursor, 
		@DBSQL nvarchar(200), 
		@SQL nvarchar(max), 
		@StatusMessage varchar(max), 
		@StatusPercent tinyint

while @AllDone = 0 begin
	select @TotalPanelClients = 0, @PanelClientCounter = 0
	insert into #DB 
	select 'A4Panel_Client_' + cast(Id as nvarchar(16)), 0 
	       from Acuity4.dbo.Client
	       where DB_ID( 'A4Panel_Client_' + cast(Id as nvarchar(16)) ) IS NOT NULL

    if @ProcessTemplateDB = 1 
	   insert into #DB values (N'A4Panel_Client_Template', 0)

	select @TotalPanelClients = count(*) 
	       from #DB

	set @PanelClientCursor = cursor scroll dynamic for select DBName from #DB for update of Processed
	open @PanelClientCursor
	fetch next from @PanelClientCursor into @ThisPanelClient
	while @@FETCH_STATUS = 0 begin
		select @PanelClientCounter += 1
		select @DBSQL = @ThisPanelClient + N'.sys.sp_executesql'
		select @StatusMessage = 'Updating panel client database "%s" (%u of %u, %u%%)', @StatusPercent = 100.0 * @PanelClientCounter / @TotalPanelClients
		raiserror (@StatusMessage, 0, 1, @ThisPanelClient, @PanelClientCounter, @TotalPanelClients, @StatusPercent) with nowait
		
		print 'Panel Client Payload 1'
		select @SQL = replace(replace(@PanelClientPayload01, '#CLIENT ID#', substring(@ThisPanelClient, 16, 8)), '#CLIENT DB#', @ThisPanelClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		print 'Panel Client Payload 2'
		select @SQL = replace(replace(@PanelClientPayload02, '#CLIENT ID#', substring(@ThisPanelClient, 16, 8)), '#CLIENT DB#', @ThisPanelClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		print 'Panel Client Payload 3'
		select @SQL = replace(replace(@PanelClientPayload03, '#CLIENT ID#', substring(@ThisPanelClient, 16, 8)), '#CLIENT DB#', @ThisPanelClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		print 'All Panel Client Payload done for panel client ' + @ThisPanelClient + '!'

		update #DB set Processed = 1 where current of @PanelClientCursor
		fetch next from @PanelClientCursor into @ThisPanelClient
	end


	close @PanelClientCursor
	deallocate @PanelClientCursor

-- Backup client template db if it was updated
	IF @ProcessTemplateDB = 1 
    BEGIN
      PRINT 'Creating backup for A4Panel_Client_Template';
      SET @SQL = 'USE A4Panel;
                  exec [dbo].[VX_sp_BackupClientTemplateDatabase]'
      EXEC (@SQL); 
    END

    SELECT @AllDone = 1
end



--select * from #DB
--select * from #Survey

drop table #DB
